function setup(){
    cnv = createCanvas(600, 600);   // 600×600ピクセルのCanvasを生成
//    cnv.position(100, 100);         // Canvasを左100ピクセル、上から100ピクセルの位置に配置
    frameRate(60);                  // 1秒間にdraw()を何回実行するか
}

function draw(){
//    clear();                        // Canvasの描画領域を全クリア
   background(271, 176, 26);      // Canvasの領域の背景色を灰色に

    angle1 = frameCount * mouseX * 0.001;   //マウスのX座標を読み取る
    angle2 = frameCount * mouseY * 0.001;   //マウスのY座標を読み取る

    let y = Math.sin(angle1 * 0.01) * 250; // y座標をsin関数で求める
                                            //frameCountは、p5.jsが保持するシステム変数。
                                            //drawが実行される度に1増える
                                            //sin関数への引数はラジアンでも度でも良いので適当に0.1倍
    let x = Math.cos(angle1*0.01) * 250; //x座標をcos関数で求める

    let smallX = x + Math.cos(angle2*0.3) * 60;
    let smallY = y + Math.sin(angle2*0.3) * 60;

    console.log(smallX, smallY);

    fill(179,34,58);   // 次の描画処理の塗りの色をRGBで指定する
    stroke(0);  // 次の描画処理の線の色を黒にする
    strokeWeight(1);    // 次の描画処理の線の太さを1にする
    line(300, 300, 300 + x, 300 + y);
    line(300 + x, 300 + y, 300 + smallX, 300 + smallY);

    noStroke();
    circle(300 + x, 300 + y , 50);  //円を描く（中心に定位させるため、x,y座標をそれぞれ+300）
    fill(107,167,206);        // 次の描画処理の塗りの色をRGBで指定する
    circle(300 + smallX, 300 + smallY , 20);  //円を描く（中心に定位させるため、x,y座標をそれぞれ+300）
}

function mouseClicked(){
    clear();
}